unit MAIN;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls, Menus, ComCtrls, ToolWin, Buttons,
  Clipbrd,
  SetSizeImageDialog, ImageBuf01, ImgScale01, About, Spin;

type
  TForm1 = class(TForm)
    ScrollBox1: TScrollBox;
    Image1: TImage;
    ControlBar1: TControlBar;
    PanelSelect: TPanel;
    SpButDrawT01: TSpeedButton;
    SpButDrawT02: TSpeedButton;
    SpButDrawT03: TSpeedButton;
    SpButDrawT04: TSpeedButton;
    PanelPen: TPanel;
    SpButPenS11: TSpeedButton;
    SpButPenS12: TSpeedButton;
    SpButPenS13: TSpeedButton;
    SpButPenS14: TSpeedButton;
    SpButPenS15: TSpeedButton;
    SpButPenS16: TSpeedButton;
    PanelBrush: TPanel;
    SpButBrush21: TSpeedButton;
    SpButBrush22: TSpeedButton;
    SpButBrush23: TSpeedButton;
    SpButBrush24: TSpeedButton;
    SpButBrush28: TSpeedButton;
    SpButBrush25: TSpeedButton;
    SpButBrush26: TSpeedButton;
    SpButBrush27: TSpeedButton;
    MainMenu1: TMainMenu;
    FileControl1: TMenuItem;
    ImgEdit1: TMenuItem;
    About1: TMenuItem;
    New1: TMenuItem;
    Open1: TMenuItem;
    Save1: TMenuItem;
    SaveAs1: TMenuItem;
    Close1: TMenuItem;
    Copy1: TMenuItem;
    Cut1: TMenuItem;
    Paste1: TMenuItem;
    StatusBar1: TStatusBar;
    STxtPenColor: TStaticText;
    STxtBrushColor: TStaticText;
    ColorDialog1: TColorDialog;
    Clear1: TMenuItem;
    OpenDialog1: TOpenDialog;
    SaveDialog1: TSaveDialog;
    View1: TMenuItem;
    PPen1: TMenuItem;
    PBrush1: TMenuItem;
    PanelAppMode1: TPanel;
    SpButModePaint: TSpeedButton;
    SpButModeText: TSpeedButton;
    PText1: TMenuItem;
    UnDo: TMenuItem;
    Select1: TMenuItem;
    ShowSelect1: TMenuItem;
    HidenSelect1: TMenuItem;
    SpButModeSelect: TSpeedButton;
    SpButModeImage: TSpeedButton;
    Copy2Buf: TMenuItem;
    Paste2Buf: TMenuItem;
    N1: TMenuItem;
    N2: TMenuItem;
    N3: TMenuItem;
    PSelect1: TMenuItem;
    SelectInBuf1: TMenuItem;
    ClearUnDo1: TMenuItem;
    PanelTxt: TPanel;
    LabelTxt: TLabel;
    EdTxt: TEdit;
    SpButOK: TSpeedButton;
    SpButCancel: TSpeedButton;
    StTxtColorTxt: TStaticText;
    SpButTxtToLeft: TSpeedButton;
    SpButTxtToCentr: TSpeedButton;
    SpButTxtToRight: TSpeedButton;
    SpButChB: TSpeedButton;
    SpButChI: TSpeedButton;
    SpButChU: TSpeedButton;
    SpButChS: TSpeedButton;
    CbBoxFntName: TComboBox;
    CbBoxFntSize: TComboBox;
    procedure FormCreate(Sender: TObject);
    //-------------------------------------------
    //  
    procedure SetAppModeClick(Sender: TObject);
    procedure SetToolAndParm(Sender: TObject);
    procedure SetColorParm(Sender: TObject);
    //-------------------------------------------
    //   Picture  Clipboard
    procedure Copy1Click(Sender: TObject);
    //   Canvas   Picture  Clipboard
    procedure Cut1Click(Sender: TObject);
    //  Clipboard  Image
    procedure Paste1Click(Sender: TObject);
    //  Image
    procedure Clear1Click(Sender: TObject);
    //-------------------------------------------
    procedure Close1Click(Sender: TObject);
    procedure SaveAs1Click(Sender: TObject);
    procedure Save1Click(Sender: TObject);
    procedure Open1Click(Sender: TObject);
    procedure New1Click(Sender: TObject);
    procedure About1Click(Sender: TObject);
    procedure PBrush1Click(Sender: TObject);
    procedure PPen1Click(Sender: TObject);
    procedure PText1Click(Sender: TObject);
    procedure UnDoClick(Sender: TObject);
    procedure ShowSelect1Click(Sender: TObject);
    procedure HidenSelect1Click(Sender: TObject);
    procedure Copy2BufClick(Sender: TObject);
    procedure Paste2BufClick(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure PSelect1Click(Sender: TObject);
    procedure SelectInBuf1Click(Sender: TObject);
    procedure ClearUnDo1Click(Sender: TObject);
    procedure EdTxtChange(Sender: TObject);
    procedure SpButOKClick(Sender: TObject);
    procedure SpButCancelClick(Sender: TObject);
    procedure StTxtColorTxtClick(Sender: TObject);
    procedure SpButTxtToLeftClick(Sender: TObject);
    procedure SpButTxtToCentrClick(Sender: TObject);
    procedure SpButTxtToRightClick(Sender: TObject);
    procedure SpButChBClick(Sender: TObject);
    procedure SpButChIClick(Sender: TObject);
    procedure SpButChUClick(Sender: TObject);
    procedure SpButChSClick(Sender: TObject);
    procedure CbBoxFntNameClick(Sender: TObject);
    procedure CbBoxFntSizeClick(Sender: TObject);
    
  private
     //-------------------------------------------
     //   -   
     procedure SelectBeg (Sender : TObject;
                          Shift: TShiftState; BegPoint, EndPoint : TPoint);
     //   -   
     procedure SelectChange (Sender : TObject;
                          Shift : TShiftState; BegPoint, EndPoint : TPoint);
     //   -   
     procedure SelectEnd (Sender : TObject; Shift : TShiftState;
                          BegPoint, EndPoint : TPoint);
     //-------------------------------------------
     //   
     procedure PanelOnOf(RqPSel, RqPPen, RqPBrush, RqPText : boolean);

  public
    { Public declarations }
  end;

var
  Form1: TForm1;

// =======================================================================
// =======================================================================  
implementation
{$R *.dfm}
uses CraphCommomTools, GraphSelectTools, GraphUnDoTools, GraphClipboardTools;
// =======================================================================
// =======================================================================
type TAppMode =(amNone, amSelect, amPaint, amText, amImg);

// =======================================================================
//     
var //  
    RegionSelector : TRegionSelector;
    //  UnDo 
    GraphUnDo      : TGraphUnDo;

// =======================================================================
//  
var //   
    CurrentFile   : string;
    //   
    WAppMode      : TAppMode;
    //      
    DrawingTool   : TRegionStyle;
    //    
    WBegPoint     : TPoint;   //  
    WEndPoint     : TPoint;   //  
    WBufPoint     : TPoint;   //   
    WNormRect     : TRect;    //  Rect 
    //   - 
    WParm : record
      SBrushStyle : TBrushStyle;
      SBrushColor : TColor;
      SPenStyle   : TPenStyle;
      SPenMode    : TPenMode;
      SPenWide    : Integer;
      SPenColor   : TColor;
    end;
    WFont         : TFont;
// -----------------------------------------------------------------------
//   ;
var ImgItm        : TImgItm;
// -----------------------------------------------------------------------
// =======================================================================
//    
// =======================================================================
// -----------------------------------------------------------------------
//   Image  
procedure ResetDrawParm(RqImage : TImage);
begin
  with RqImage.Canvas do
  begin
    Pen.Style   := WParm.SPenStyle;
    Pen.Mode    := WParm.SPenMode;
    Pen.Width   := WParm.SPenWide;
    Pen.Color   := WParm.SPenColor;
    Brush.Color := WParm.SBrushColor;
    Brush.Style := WParm.SBrushStyle;
  end;
end;
// -----------------------------------------------------------------------
//   Image  
procedure ClearImage (RqImage : TImage; RqColor : TColor);
begin
  with RqImage.Canvas do
  begin
    Brush.Style := bsSolid;
    Brush.Color := RqColor;
    FillRect(Rect(0,0, RqImage.Width, RqImage.Height));
  end;
end;
// -----------------------------------------------------------------------
//    Image   .
procedure DrawTextToImage(RqImage : TImage; RqFont : TFont;
                          RqBeg : TPoint; RqText : string);
begin
   with RqImage.Canvas do
   begin
     //   
     Font := RqFont;
     //    
     if fsItalic in Font.Style
     //   TextWidth   Italic
     then WBufPoint.X := RqBeg.X + 2 * TextWidth (RqText)
     else WBufPoint.X := RqBeg.X + TextWidth (RqText);
     WBufPoint.Y := RqBeg.Y - TextHeight(RqText);
     //      TRect
     WNormRect := NoarmalRect (RqBeg, WBufPoint);
     //  BitMap     UnDo
     if Assigned(GraphUnDo)
     then GraphUnDo.SaveUnDoBitMap(RqImage, WNormRect);
     //   
     Brush.Color := WParm.SBrushColor;
     Brush.Style := WParm.SBrushStyle;
     TextOut(RqBeg.X, WBufPoint.Y, RqText);
   end;
end;
// -----------------------------------------------------------------------
//     .
// 29.05.2014 ()
procedure DrawFigureToImage(RqImage            : TImage;
                            RqRegionStyle      : TRegionStyle;
                            BegPoint, EndPoint : TPoint;
                            NmRect             : Trect);
begin
  with RqImage.Canvas do
  begin
    case RqRegionStyle of
    dtLine:
        begin
          MoveTo(BegPoint.X, BegPoint.Y);
          LineTo(EndPoint.X, EndPoint.Y);
        end;
    dtRectangle:
        Rectangle(NmRect);
    dtEllipse:
        Ellipse(NmRect);
    dtRoundRect:
        RoundRect(NmRect.Left, NmRect.Top,
                  NmRect.Right, NmRect.Bottom,
                 (NmRect.Right  - NmRect.Left) div 2,
                 (NmRect.Bottom - NmRect.Top)  div 2);
    end;
  end;
end;
// -----------------------------------------------------------------------
//   BitMap    TPicture
procedure SetNewBitMapToPicture (RqPicture : TPicture;
                                 RqW, RqH  : integer);
var Bitmap: TBitmap;
begin
  Bitmap := nil;
  try
    Bitmap := TBitmap.Create;
    BitMap.PixelFormat := pf24bit;
    Bitmap.Width  := RqW;
    Bitmap.Height := RqH;
    //   graphic    TPicture
    //    bitmap, icon, metafile 
    // user-defined graphic class.
     RqPicture.Graphic := Bitmap;
  finally
    Bitmap.Free;
  end;
end;

// -----------------------------------------------------------------------
// =======================================================================
//    Clipboard (  unit : GraphClipboardTools )
// =======================================================================
// -----------------------------------------------------------------------
//   Picture  Clipboard
procedure TForm1.Copy1Click(Sender: TObject);
begin
  //  Picture  Clipboard
  CopyBitMapToClipboard (Image1.Picture.Bitmap);
end;
// -----------------------------------------------------------------------
//   Canvas   Picture  Clipboard
// 28.05.2014 ()
procedure TForm1.Cut1Click(Sender: TObject);
begin
  //  Picture  Clipboard
  if CopyBitMapToClipboard (Image1.Picture.Bitmap)
  then begin
     if Assigned(GraphUnDo)
     then begin
        GraphUnDo.ClearUnDo();
        UnDo.Caption := '  (' + IntToStr(GraphUnDo.UnDoCount) + ')';
     end;
     //  Canvas
     ClearImage(Image1, Image1.Parent.Brush.Color);
  end;
end;
// -----------------------------------------------------------------------
//  Clipboard  Image
// 28.05.2014 ()
procedure TForm1.Paste1Click(Sender: TObject);
begin
  //  Clipboard  Image
  if PasteBitMapFromClipboard(0,0, Image1.Picture.Bitmap)
  then begin
    //   UnDo
    if Assigned(GraphUnDo)
    then begin
        GraphUnDo.ClearUnDo();
        UnDo.Caption := '  (' + IntToStr(GraphUnDo.UnDoCount) + ')';
    end;
  end;
end;

// -----------------------------------------------------------------------
// =======================================================================
//      
// =======================================================================
// -----------------------------------------------------------------------
// 27.05.2014
//      
procedure CopyToBuf(RqImg : TImage; var RqRect : Trect);
begin
  //  
  with RqRect do if (Right - Left <= 0) or (Bottom - Top <= 0) then Exit;
  //  
  try
    if not Assigned(ImgItm.BitMap)
    then ImgItm.BitMap := TBitMap.Create;
    ImgItm.BitMap.PixelFormat := pf24bit;
    //   
    RegionSelector.RegionVisible(False);
    RqImg.Repaint;
    //  
    GetBitMapFromImage (RqImg, RqRect, ImgItm.BitMap);
    ImgItm.SrcRect := RqRect;
    //   
    RegionSelector.RegionToZero();
    RqRect := RegionSelector.Region;
  except
    ShowMessage('     ');
  end;
end;
// -----------------------------------------------------------------------
// 18.06.2014  ()
//     
procedure TForm1.Copy2BufClick(Sender: TObject);
begin
  if SpButModeImage.Down
  then begin
    CopyToBuf(Image1, WNormRect);
    FormImgBuf.AddImgItem(ImgItm);
  end
  else begin
     //     
     RegionSelector.RegionToZero();
     if MessageDlg('   -  '
                    + #13#10 + '  ?',
                    mtConfirmation, [mbYes, mbNo], 0) = mrYes
     then begin
        SpButModeImage.Down := True;
        SetAppModeClick(TObject(SpButModeImage));
     end;
  end;
end;
// -----------------------------------------------------------------------
// 28.05.2014
//     (  )
procedure TForm1.SelectInBuf1Click(Sender: TObject);
begin
  FormImgBuf.ShowModal;
end;
// -----------------------------------------------------------------------
// 27.05.2014
//  a    
function PasteFromBuf(RqBitMap : TBitMap;
                      RqImg : TImage;
                  var RqRect : Trect): boolean;
begin
  Result := False;
  //  
  with RqRect do if (Right - Left <= 0) or (Bottom - Top <= 0) then Exit;
  if not Assigned(RqBitMap) then Exit;
  //  
  try
    //   
    RegionSelector.RegionVisible(False);
    RqImg.Repaint;
    //     ( )
    with RqRect
    do begin
      if (Right - Left) > RqBitMap.Width
      then Right := Left + RqBitMap.Width;
      if(Bottom - Top > RqBitMap.Height)
      then Bottom := Top + RqBitMap.Height;
    end;  
    //  BitMap   ( )
    //     UnDo
    if Assigned(GraphUnDo)
    then GraphUnDo.SaveUnDoBitMap(RqImg, RqRect);
    //  BitMap     RqRect
    SetBitMapToImage (RqImg, RqRect, RqBitMap);
    //   
    RegionSelector.RegionToZero();
    RqRect := RegionSelector.Region;
    Result := True;
  except
    ShowMessage('     ');
  end;
end;
// -----------------------------------------------------------------------
// 18.06.2014 ()
//     
procedure TForm1.Paste2BufClick(Sender: TObject);
begin
  if SpButModeImage.Down
  then begin
     //      TRect
     with RegionSelector do WNormRect := NoarmalRect(BegPoint, EndPoint);
     //      
     FormImgBuf.GetImgItem (ImgItm);
     //  
     if PasteFromBuf(ImgItm.BitMap, Image1, WNormRect)
     then begin
        //    UnDo
        if Assigned(GraphUnDo)
        then UnDo.Caption := '  (' + IntToStr(GraphUnDo.UnDoCount) + ')';
     end;
  end
  else begin
     //     
     RegionSelector.RegionToZero();
     if MessageDlg('   -  '
                    + #13#10 + '  ?',
                    mtConfirmation, [mbYes, mbNo], 0) = mrYes
     then begin
        SpButModeImage.Down := True;
        SetAppModeClick(TObject(SpButModeImage));
     end;
  end;
end;

// -----------------------------------------------------------------------
// =======================================================================
//      
// =======================================================================
// -----------------------------------------------------------------------
// 30.05.2014
//      Label
procedure PrepareTextArea (RqScrollBox : TScrollBox;
                           RqLabel     : TLabel;
                           RqNmRec     : TRect);
var XSB, YSB : integer;
begin
    //     ScrollBox
    XSB := RqScrollBox.HorzScrollBar.Position;
    YSB := RqScrollBox.VertScrollBar.Position;
    //     
    RqLabel.AutoSize := False;
    RqLabel.WordWrap := True;
    //        Image
    //      RqLabel  ScrollBox
    RqLabel.Top    := RqNmRec.Top  + 1 - YSB;
    RqLabel.Left   := RqNmRec.Left + 1 - XSB;
    RqLabel.Width  := RqNmRec.Right - RqNmRec.Left - 2;
    RqLabel.Height := RqNmRec.Bottom - RqNmRec.Top - 2;
    //     
    RqLabel.Transparent := True;
    RqLabel.Visible := True;
    //     
    RqLabel.Repaint;
end;
// -----------------------------------------------------------------------
// 30.05.2014
//      Label
procedure TForm1.EdTxtChange(Sender: TObject);
begin
   LabelTxt.Caption := EdTxt.Text;
end;
// -----------------------------------------------------------------------
// 30.05.2014
//   Label   
procedure CancelTxt(RqLabel : TLabel);
begin
   RqLabel.Left    := 0;
   RqLabel.Top     := 0;
   RqLabel.Height  := 1;
   RqLabel.Width   := 1;
   RqLabel.Visible := False;
end;
// -----------------------------------------------------------------------
// 30.05.2014
//    
procedure TForm1.SpButOKClick(Sender: TObject);
var  XB, YB   : integer;
     XSB, YSB : integer;
     RectSrc, RectDest : TRect;
begin
  if (LabelTxt.Width > 1) and (LabelTxt.Height > 1)
  then begin
     //     ScrollBox
     XSB := ScrollBox1.HorzScrollBar.Position;
     YSB := ScrollBox1.VertScrollBar.Position;
     //    Image
     XB := LabelTxt.Left + XSB;
     YB := LabelTxt.Top  + YSB;
     RectSrc  :=  Rect(0,0,LabelTxt.Width, LabelTxt.Height);
     RectDest :=  Rect(XB, YB, XB + LabelTxt.Width, YB + LabelTxt.Height);
     RegionSelector.RegionVisible(False);
     LabelTxt.Repaint;
     LabelTxt.Visible := False;
     //  BitMap   ( )
     //     UnDo
     if Assigned(GraphUnDo)
     then  begin
         GraphUnDo.SaveUnDoBitMap(Image1, RectDest);
         UnDo.Caption := '  ('
                       + IntToStr(GraphUnDo.UnDoCount) + ')';
     end;
     //     LabelTxt  Image
     Image1.Canvas.CopyRect(RectDest, LabelTxt.Canvas, RectSrc);
     //  LabelTxt   
     CancelTxt(LabelTxt);
  end
  else begin
     MessageDlg('   '
              + #13#10
              + '    .',
                mtInformation, [mbOk], 0);
  end;
end;
// -----------------------------------------------------------------------
// 30.05.2014
//     
procedure TForm1.SpButCancelClick(Sender: TObject);
begin
   RegionSelector.RegionVisible(False);
   CancelTxt(LabelTxt);
end;
// -----------------------------------------------------------------------
//         Label
// -----------------------------------------------------------------------
// 30.05.2014
//   
procedure TForm1.StTxtColorTxtClick(Sender: TObject);
begin
  if ColorDialog1.Execute
  then begin
    LabelTxt.Font.Color := ColorDialog1.Color;
    StTxtColorTxt.Color := ColorDialog1.Color;
    LabelTxt.Repaint;
  end;
end;
// -----------------------------------------------------------------------
// 30.05.2014
//     
procedure TForm1.SpButTxtToLeftClick(Sender: TObject);
begin
   LabelTxt.Alignment := taLeftJustify;
   LabelTxt.Repaint;
end;
// -----------------------------------------------------------------------
// 30.05.2014
//    
procedure TForm1.SpButTxtToCentrClick(Sender: TObject);
begin
   LabelTxt.Alignment := taCenter;
   LabelTxt.Repaint;
end;
// -----------------------------------------------------------------------
// 30.05.2014
//     
procedure TForm1.SpButTxtToRightClick(Sender: TObject);
begin
   LabelTxt.Alignment := taRightJustify;
   LabelTxt.Repaint;
end;
// -----------------------------------------------------------------------
//    Bold, Italic, Underline, StrikeOut
// -----------------------------------------------------------------------
// 30.05.2014
procedure TForm1.SpButChBClick(Sender: TObject);
begin
   if SpButChB.Down
   then LabelTxt.Font.Style := LabelTxt.Font.Style + [fsBold]
   else LabelTxt.Font.Style := LabelTxt.Font.Style - [fsBold];
   LabelTxt.Repaint;
end;
// -----------------------------------------------------------------------
// 30.05.2014
procedure TForm1.SpButChIClick(Sender: TObject);
begin
   if SpButChI.Down
   then LabelTxt.Font.Style := LabelTxt.Font.Style + [fsItalic]
   else LabelTxt.Font.Style := LabelTxt.Font.Style - [fsItalic];
   LabelTxt.Repaint;
end;
// -----------------------------------------------------------------------
// 30.05.2014
procedure TForm1.SpButChUClick(Sender: TObject);
begin
   if SpButChU.Down
   then LabelTxt.Font.Style := LabelTxt.Font.Style + [fsUnderline]
   else LabelTxt.Font.Style := LabelTxt.Font.Style - [fsUnderline];
   LabelTxt.Repaint;
end;
// -----------------------------------------------------------------------
// 30.05.2014
procedure TForm1.SpButChSClick(Sender: TObject);
begin
   if SpButChS.Down
   then LabelTxt.Font.Style := LabelTxt.Font.Style + [fsStrikeOut]
   else LabelTxt.Font.Style := LabelTxt.Font.Style - [fsStrikeOut];
   LabelTxt.Repaint;
end;
// -----------------------------------------------------------------------
//      Font.Name, Font.Size
//      .  FormCreate
// -----------------------------------------------------------------------
// 31.05.2014
//        tag
const tftNONE   = 0;     //  font ( unknown font type   )
      tftTTF    = 1;     // True type font   (   )
      tftRASTER = 2;     //  font   ( raster font         )
      tftDEVICE = 3;     //    ( device font         )
// -----------------------------------------------------------------------
// 31.05.2014
//    EnumFontFamilies
//      
//  box (: TlistBox, TComboBox   )
function EnumProc(var elf: TEnumLogFont; var ntm: TNewTextmetric;
  fonttype: Integer; box: TComboBox): Integer; stdcall;
begin
  case fonttype of
    TRUETYPE_FONTTYPE :  box.Tag := tftTTF;
    RASTER_FONTTYPE   : begin
        box.Tag := tftRASTER;
        box.Items.Add(Format('%d', [elf.elfLogFont.lfHeight]));
    end;
    DEVICE_FONTTYPE   : box.Tag := tftDEVICE;  // device font
    else box.Tag := tftNONE;                   // unknown font type
  end;
  Result := 1;
end;
// -----------------------------------------------------------------------
// 31.05.2014
//    Font.Size   
procedure PrepareFontSize(RqForm     : TForm;       //   
                          RqFontName : string;      //  
                          RqBox      : TComboBox);  // Box   
//   Font.Size  TTF 
const TTFSize : array [0..15] of integer =
(8,9,10,11,12,14,16,18,20,22,24,26,28,36,48,72);
var Ind : integer;
begin
  RqBox.clear;
  if RqFontName <> ''
  then begin
     //       (API)
     EnumFontFamilies(RqForm.Canvas.Handle,
                      PChar(RqFontName),
                      @EnumProc, Longint(RqBox));
     case RqBox.Tag of
     tftTTF    : begin
                  for Ind := Low(TTFSize) to High(TTFSize)
                  do RqBox.Items.Add(IntToStr(TTFSize[Ind]));
                 end;
     tftRASTER : begin end;
     else RqBox.Items.Add('8');
     end;
     if RqBox.Items.Count > 0 then RqBox.ItemIndex := 0;
  end;
end;
// -----------------------------------------------------------------------
// 31.05.2014
//   
procedure TForm1.CbBoxFntNameClick(Sender: TObject);
var IndN : integer;
begin
  IndN := CbBoxFntName.ItemIndex;
  if IndN >=0
  then begin
     //    
     PrepareFontSize(Self, CbBoxFntName.Items[IndN], CbBoxFntSize);
     //          LabelTxt
     if (CbBoxFntSize.Items.Count > 0)
     then begin
        LabelTxt.Font.Name := CbBoxFntName.Items[IndN];
        LabelTxt.Font.Size := StrToInt(CbBoxFntSize.Items[0]);
     end;
  end;
end;
// -----------------------------------------------------------------------
// 31.05.2014
//   
procedure TForm1.CbBoxFntSizeClick(Sender: TObject);
var IndN, IndS : integer;
begin
  //          LabelTxt
  if (CbBoxFntSize.Items.Count > 0)
  then begin
     IndN := CbBoxFntName.ItemIndex;
     IndS := CbBoxFntSize.ItemIndex;
     if (IndN >= 0) and (IndS >= 0)
     then begin
        LabelTxt.Font.Name := CbBoxFntName.Items[IndN];
        LabelTxt.Font.Size := StrToInt(CbBoxFntSize.Items[IndS]);
        LabelTxt.Repaint;
     end;
  end;
end;

// -----------------------------------------------------------------------
// =======================================================================
//         
// =======================================================================
// -----------------------------------------------------------------------
//   -   
procedure TForm1.SelectBeg (Sender : TObject;
                 Shift: TShiftState; BegPoint, EndPoint : TPoint);
begin
 with BegPoint
 do begin
    WBegPoint := BegPoint;   //   
    StatusBar1.Panels[0].Text := Format(' : (%d, %d)', [X, Y]);
    StatusBar1.Panels[1].Text := '';
    StatusBar1.Panels[2].Text := '';
    StatusBar1.Panels[3].Text := '';
 end;
end;
// -----------------------------------------------------------------------
//   -   
// 28.05.2014 ()
procedure TForm1.SelectChange (Sender : TObject;
                 Shift : TShiftState; BegPoint, EndPoint : TPoint);
var WH : integer;
begin
  if not (WAppMode = amNone)
  then begin
    with EndPoint do
    StatusBar1.Panels[1].Text := Format(' : (%d, %d)', [X, Y]);
    WH := Abs(EndPoint.X - BegPoint.X);
    StatusBar1.Panels[2].Text := Format(' : (%d)', [WH]);
    WH := Abs(EndPoint.Y - BegPoint.Y);
    StatusBar1.Panels[3].Text := Format(' : (%d)', [WH]);
  end;
end;

// -----------------------------------------------------------------------
//   -   
// 29.05.2014 ()
procedure TForm1.SelectEnd (Sender : TObject;
                 Shift : TShiftState; BegPoint, EndPoint : TPoint);
begin
  WEndPoint := EndPoint;  //   
  case WAppMode of
  amPaint: begin //   - 
           if not EqualPoints(BegPoint, EndPoint)
           then begin
              //      TRect
              WNormRect := NoarmalRect (BegPoint, EndPoint);
              //  BitMap   UnDo
              if Assigned(GraphUnDo)
              then GraphUnDo.SaveUnDoBitMap(Image1, WNormRect);
              //    
              ResetDrawParm(Image1);
              //  
              DrawFigureToImage (Image1, DrawingTool,
                                 BegPoint, EndPoint,
                                 WNormRect);
           end;
           end;
  amText: begin //   -  (   30.05.2014)
             if not EqualPoints(BegPoint, EndPoint)
             then begin
                //      TRect
                WNormRect := NoarmalRect (BegPoint, EndPoint);
                //    
                ResetDrawParm(Image1);
                //        Image
                PrepareTextArea (ScrollBox1, LabelTxt, WNormRect);
             end;
          end;
  amImg : begin //   - Image Copy/Paste Bufer
           if not EqualPoints(BegPoint, EndPoint)
           then begin
              //      TRect
              WNormRect := NoarmalRect (BegPoint, EndPoint);
           end;
          end;
  end;
  //   UnDo
  if Assigned(GraphUnDo)
  then UnDo.Caption := '  ('
                      + IntToStr(GraphUnDo.UnDoCount) + ')';
end;
// -----------------------------------------------------------------------
// =======================================================================
//     
// =======================================================================
// -----------------------------------------------------------------------
//   Image   Brush
// 28.05.2014 ()
procedure TForm1.Clear1Click(Sender: TObject);
begin
  if MessageDlg('     Brush!'
         + #13#10 + '?',
         mtConfirmation, [mbYes, mbNo], 0) = mrYes
  then begin
    if Assigned(GraphUnDo)
    then begin
        GraphUnDo.ClearUnDo();
        UnDo.Caption := '  (' + IntToStr(GraphUnDo.UnDoCount) + ')';
    end;
    ClearImage(Image1, STxtBrushColor.Color);
  end;
end;
// -----------------------------------------------------------------------
//       
// 28.05.2014 ()
procedure TForm1.New1Click(Sender: TObject);
var SaveW, SaveH, NewW, NewH : integer;
begin
  LabelTxt.Visible := False;
  //     
  RegionSelector.RegionToZero();
  SpButModeSelect.Down := True;
  SetAppModeClick(TObject(SpButModeSelect));

  //    
  SaveW := Image1.Picture.Graphic.Width;
  SaveH := Image1.Picture.Graphic.Height;
  if Assigned(GraphUnDo)
  then begin
      GraphUnDo.ClearUnDo();
      UnDo.Caption := '  (' + IntToStr(GraphUnDo.UnDoCount) + ')';
  end;
  with NewImageForm do
  begin
    //    WidthEdit
    ActiveControl := WidthEdit;
    //    
    WidthEdit.Text  := IntToStr(SaveW);
    HeightEdit.Text := IntToStr(SaveH);
    //   
    if ShowModal <> idCancel then
    begin
      try
        //    
        NewW := StrToInt(WidthEdit.Text);
        NewH := StrToInt(HeightEdit.Text);
        //   BitMap    TPicture
        SetNewBitMapToPicture (Image1.Picture, NewW, NewH);
        //      
        Image1.Canvas.Brush.Color := STxtColor.Color;
        Image1.Canvas.FillRect(Rect(0,0,NewW,NewH));
        //      
        CurrentFile := EmptyStr;
        //     Image
        ResetDrawParm(Image1);
      except
        //     Image
        ResetDrawParm(Image1);
        MessageDlg('  '
              + #13#10
              + '  ...',
                mtError, [mbOk], 0);
      end;
    end;
  end;
end;
// -----------------------------------------------------------------------
//    
procedure TForm1.Open1Click(Sender: TObject);
begin
  OpenDialog1.Filter := 'Graphics files (*.bmp)|*.BMP';
  if OpenDialog1.Execute then
  begin
    LabelTxt.Visible := False;
    //     
    RegionSelector.RegionToZero();
    SpButModeSelect.Down := True;
    SetAppModeClick(TObject(SpButModeSelect));
    try
      CurrentFile := OpenDialog1.FileName;
      Image1.Picture.LoadFromFile(CurrentFile);
      Image1.Picture.Bitmap.PixelFormat := pf24bit;
      if Assigned(GraphUnDo)
      then begin
          GraphUnDo.ClearUnDo();
          UnDo.Caption := '  (' + IntToStr(GraphUnDo.UnDoCount) + ')';
      end;
      //    Image
      ResetDrawParm(Image1);
    except
       MessageDlg('   '
              + #13#10
              + CurrentFile,
                mtError, [mbOk], 0);
    end;
  end;
end;
// -----------------------------------------------------------------------
//        
procedure TForm1.Save1Click(Sender: TObject);
begin
  if CurrentFile <> EmptyStr then
    Image1.Picture.SaveToFile(CurrentFile)
  else SaveAs1Click(Sender);
end;
procedure TForm1.SaveAs1Click(Sender: TObject);
begin
  SaveDialog1.Filter := 'Graphics files (*.bmp)|*.BMP';
  if SaveDialog1.Execute then
  begin
    CurrentFile := SaveDialog1.FileName;
    Save1Click(Sender);
  end;
end;
// -----------------------------------------------------------------------
//    
// 26.05.2014 ()
procedure SetRegionSelector(RqRS      : TRegionSelector;
                            RqAppMode : TAppMode);
begin
  //     
  if Assigned(RqRS)
  then begin
     //   
     RqRS.RegionVisible(False);
     case RqAppMode of
      amSelect : RqRS.ReSetRegionMode(rmRegionOnly);
      amPaint  : RqRS.ReSetRegionMode(rmPaintShape);
      amText   : RqRS.ReSetRegionMode(rmRegionOnly);    // rmPaintShape
      amImg    : begin
                   RqRS.ReSetRegionMode(rmRegionOnly);
                   //   
                   RqRS.RqShape := dtRectangle;
                 end;
     end;
  end;
end;

// -----------------------------------------------------------------------
// =======================================================================
//   
// =======================================================================
// -----------------------------------------------------------------------
//     
// -----------------------------------------------------------------------
//  -   Select
procedure TForm1.PSelect1Click(Sender: TObject);
begin
  PanelSelect.Visible := PSelect1.Checked;
end;
// -----------------------------------------------------------------------
//  -   Pen
procedure TForm1.PPen1Click(Sender: TObject);
begin
  PanelPen.Visible := PPen1.Checked;
end;
// -----------------------------------------------------------------------
//  -   Brush
procedure TForm1.PBrush1Click(Sender: TObject);
begin
  PanelBrush.Visible := PBrush1.Checked;
end;
// -----------------------------------------------------------------------
//  -   Text
procedure TForm1.PText1Click(Sender: TObject);
begin
  PanelTxt.Visible := PText1.Checked;
end;
// -----------------------------------------------------------------------
// 28.05.2014
//   
procedure TForm1.PanelOnOf(RqPSel, RqPPen, RqPBrush, RqPText : boolean);
begin
    PSelect1.Checked := RqPSel;
    PSelect1Click(Self);
    PPen1.Checked := RqPPen;
    PPen1Click(Self);
    PBrush1.Checked := RqPBrush;
    PBrush1Click(Self);
    PText1.Checked := RqPText;
    PText1Click(Self);
end;
// -----------------------------------------------------------------------
// 28.05.2014 ()
//   
procedure TForm1.SetAppModeClick(Sender: TObject);
begin
   with (Sender as TComponent)
   do begin
      case Tag of
      1001 : begin  //  
               //   
               PanelOnOf(True, False, False, False);
               SetRegionSelector (RegionSelector, amSelect);
               WAppMode := amSelect;
               LabelTxt.Visible := False;
               //     
               RegionSelector.RegionToZero();
             end;
      1002 : begin  //  
               //   
               PanelOnOf(True, True, True, False);
               SetRegionSelector (RegionSelector, amPaint);
               WAppMode := amPaint;
               LabelTxt.Visible := False;
               //     
               RegionSelector.RegionToZero();
             end;  
      1003 : begin  //   
               //   
               PanelOnOf(False, False, False, True);
               SetRegionSelector (RegionSelector, amText);
               WAppMode := amText;
               LabelTxt.Visible := False;
               //     
               RegionSelector.RegionToZero();
             end;
      1004 : begin  //   BitMap 
               SpButDrawT02.Down := True;
               //   
               PanelOnOf(False, False, False, False);
               SetRegionSelector (RegionSelector, amImg);
               WAppMode := amImg;
               LabelTxt.Visible := False;
               //     
               RegionSelector.RegionToZero();
             end;
      end;
   end;
end;
// -----------------------------------------------------------------------
//         
//  DesignTime   Tag  
procedure TForm1.SetToolAndParm(Sender: TObject);
begin
  with (Sender as TComponent)
  do begin
     case Tag of
       1 : DrawingTool := dtLine;
       2 : DrawingTool := dtRectangle;
       3 : DrawingTool := dtEllipse;
       4 : DrawingTool := dtRoundRect;
       //   Pen.Style
       11: WParm.SPenStyle := psSolid;
       12: WParm.SPenStyle := psDash;
       13: WParm.SPenStyle := psDot;
       14: WParm.SPenStyle := psDashDot;
       15: WParm.SPenStyle := psDashDotDot;
       16: WParm.SPenStyle := psClear;
       //   Brush.Style
       21: WParm.SBrushStyle := bsSolid;
       22: WParm.SBrushStyle := bsClear;
       23: WParm.SBrushStyle := bsHorizontal;
       24: WParm.SBrushStyle := bsVertical;
       25: WParm.SBrushStyle := bsFDiagonal;
       26: WParm.SBrushStyle := bsBDiagonal;
       27: WParm.SBrushStyle := bsCross;
       28: WParm.SBrushStyle := bsDiagCross;
     end;
     RegionSelector.RqShape    := DrawingTool;
     Image1.Canvas.Pen.Style   := WParm.SPenStyle;
     Image1.Canvas.Brush.Style := WParm.SBrushStyle;
  end;
end;
// -----------------------------------------------------------------------
//   Pen  Brush
procedure TForm1.SetColorParm(Sender: TObject);
begin
 if ColorDialog1.Execute
 then begin
   with (Sender as TComponent)
   do begin
       case Tag of
       101: WParm.SPenColor   := ColorDialog1.Color;
       102: WParm.SBrushColor := ColorDialog1.Color;
       end;
   end;
   STxtPenColor.Color   := WParm.SPenColor;
   STxtBrushColor.Color := WParm.SBrushColor;
 end
end;

// -----------------------------------------------------------------------
// =======================================================================
//    UnDo 
// =======================================================================
// -----------------------------------------------------------------------
//   
procedure TForm1.UnDoClick(Sender: TObject);
begin
  if Assigned(GraphUnDo)
  then begin
     GraphUnDo.RestoreUnDoBitMap(Image1);
     UnDo.Caption := '  (' + IntToStr(GraphUnDo.UnDoCount) + ')';
  end;
end;
// -----------------------------------------------------------------------
// 28.05.2014
//    UnDo
procedure TForm1.ClearUnDo1Click(Sender: TObject);
begin
  if Assigned(GraphUnDo)
  then begin
      if GraphUnDo.UnDoCount = 0 then Exit;
      if MessageDlg('    !'
         + #13#10 + '?',
         mtConfirmation, [mbYes, mbNo], 0) = mrYes then
      begin
        GraphUnDo.ClearUnDo();
        UnDo.Caption := '  (' + IntToStr(GraphUnDo.UnDoCount) + ')';
      end;
  end;
end;

// =======================================================================
//   (  )
procedure TForm1.ShowSelect1Click(Sender: TObject);
begin
  if (WAppMode = amSelect) and Assigned(RegionSelector)
  then RegionSelector.RegionVisible (True);
end;
// -----------------------------------------------------------------------
//   (  )
procedure TForm1.HidenSelect1Click(Sender: TObject);
begin
  if ((WAppMode = amSelect) or (WAppMode = amImg))
      and Assigned(RegionSelector)
  then RegionSelector.RegionVisible( False);
end;

// -----------------------------------------------------------------------
// =======================================================================
//    -  
// =======================================================================
// -----------------------------------------------------------------------
//   
procedure TForm1.FormCreate(Sender: TObject);
begin
   SetNewBitMapToPicture (Image1.Picture, Image1.Width, Image1.Height);
   //   
   WAppMode := amSelect;   //   (  )
   //------------------------------------------------
   //  
   //  -
   RegionSelector := TRegionSelector.Create(Image1);
   if Assigned(RegionSelector)
   then begin
     RegionSelector.RqShape := dtRectangle;
     RegionSelector.OnSelectBeg := SelectBeg;
     RegionSelector.OnSelectChange := SelectChange;
     RegionSelector.OnSelectEnd := SelectEnd;
     RegionSelector.RegionVisible(True);
   end;
   //   GraphUnDo
   GraphUnDo :=  TGraphUnDo.Create;
   //------------------------------------------------
   // 31.05.2014
   //   ComboBox    
   CbBoxFntName.Items.Assign(Screen.Fonts);
   if CbBoxFntName.Items.Count > 0
   then begin
     //   'Arial'   ComboBox   
     CbBoxFntName.ItemIndex := CbBoxFntName.Items.IndexOf('Arial');
     PrepareFontSize(Self,
                     CbBoxFntName.Items[CbBoxFntName.ItemIndex],
                     CbBoxFntSize);
     //          LabelTxt
     if (CbBoxFntSize.Items.Count > 0)
     then begin
        LabelTxt.Font.Name := CbBoxFntName.Items[CbBoxFntName.ItemIndex];
        LabelTxt.Font.Size := StrToInt(CbBoxFntSize.Items[0]);
     end;
   end;
   //------------------------------------------------
   //     
   DrawingTool        := dtRectangle;
   SpButDrawT02.Down  := True;
   WParm.SBrushStyle  := bsClear;
   SpButBrush22.Down  := True;
   WParm.SBrushColor  := clSilver;
   STxtBrushColor.Color := clSilver;
   WParm.SPenStyle    := psSolid;
   SpButPenS11.Down   := True;
   WParm.SPenMode     := pmCopy;
   WParm.SPenWide     := 1;
   WParm.SPenColor    := clBlue;
   STxtPenColor.Color := clBlue;
   //   
   WFont := Self.Font;
   //    Image
   ResetDrawParm(Image1);
   //   
   PanelOnOf(True, False, False, False);

end;
// -----------------------------------------------------------------------
// 27.05.2014
//      
procedure TForm1.FormDestroy(Sender: TObject);
begin
  GraphUnDo.Free;
  RegionSelector.Free;
end;
// -----------------------------------------------------------------------
//  
procedure TForm1.Close1Click(Sender: TObject);
begin
  Self.Close;
end;

// -----------------------------------------------------------------------
//  
procedure TForm1.About1Click(Sender: TObject);
begin
   AboutBox.ShowModal;
end;

// =======================================================================
// =======================================================================


end.
// =======================================================================
// =======================================================================
